/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.maven.asciidoc.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class FileUtils
extends org.apache.commons.io.FileUtils {
    private static File temporaryDirectory;

    public static String getAsciidocTemporaryPath(String filename, String extension) throws IOException {
        File file = new File(filename);
        StringBuilder builder = new StringBuilder();
        builder.append(FileUtils.getTemporayAsciidoc());
        builder.append(File.separator);
        builder.append(file.getName());
        builder.append(extension);
        return builder.toString();
    }

    public static void moveFileToDirectory(String fileName, String directoryName) throws IOException {
        File file = new File(fileName);
        File directory = new File(directoryName);
        File destFile = FileUtils.getFile((File)directory, (String[])new String[]{file.getName()});
        if (destFile.exists()) {
            FileUtils.forceDelete((File)destFile);
        }
        FileUtils.moveFileToDirectory((File)file, (File)directory, (boolean)true);
    }

    public static String getTemporayAsciidoc() throws IOException {
        if (temporaryDirectory == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(FileUtils.getTempDirectoryPath());
            builder.append(File.separator);
            builder.append("asciidoc-maven-plugin");
            builder.append(Long.toString(System.nanoTime()));
            temporaryDirectory = new File(builder.toString());
            FileUtils.forceMkdir((File)temporaryDirectory);
            FileUtils.forceDeleteOnExit((File)temporaryDirectory);
        }
        return temporaryDirectory.getAbsolutePath();
    }

    public static String uncompress(InputStream is, String destination) throws IOException {
        BufferedInputStream in = new BufferedInputStream(is);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
        TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)gzIn);
        TarArchiveEntry entry = tarInput.getNextTarEntry();
        do {
            File f = new File(destination + "/" + entry.getName());
            FileUtils.forceMkdir((File)f.getParentFile());
            if (f.isDirectory()) continue;
            FileOutputStream os = new FileOutputStream(f);
            byte[] content = new byte[(int)entry.getSize()];
            int byteRead = 0;
            while ((long)byteRead < entry.getSize()) {
                byteRead += tarInput.read(content, byteRead, content.length - byteRead);
                ((OutputStream)os).write(content, 0, byteRead);
            }
            ((OutputStream)os).close();
            FileUtils.forceDeleteOnExit((File)f);
        } while ((entry = tarInput.getNextTarEntry()) != null);
        gzIn.close();
        return destination;
    }
}

