/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.maven.asciidoc.backends;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.rwx.maven.asciidoc.backends.AsciidocBackend;

public class AsciidocBackendSingleton {
    private static AsciidocBackendSingleton instance;
    private Map<String, AsciidocBackend> map = new HashMap<String, AsciidocBackend>();

    private AsciidocBackendSingleton() throws IOException {
        this.map.put("html5", new AsciidocBackend("html5", ".html"));
        this.map.put("xhtml11", new AsciidocBackend("xhtml11", ".html"));
        this.map.put("html4", new AsciidocBackend("html4", ".html"));
        this.map.put("slidy", new AsciidocBackend("slidy", ".html"));
        this.map.put("docbook", new AsciidocBackend("docbook", ".xml"));
        this.map.put("pdf", new AsciidocBackend("docbook", ".xml", ".fo", "fo/docbook.xsl"));
    }

    public static AsciidocBackendSingleton getInstance() {
        if (instance == null) {
            try {
                instance = new AsciidocBackendSingleton();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return instance;
    }

    public AsciidocBackend getBackend(String name) {
        return this.map.get(name);
    }
}

