/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.maven.asciidoc.backends;

import java.io.File;
import java.io.IOException;
import net.rwx.maven.asciidoc.backends.AsciidocBackendTransformation;
import net.rwx.maven.asciidoc.utils.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class AsciidocBackend {
    private String name;
    private String extension;
    private AsciidocBackendTransformation[] transformations;
    private File temporaryDirectory;

    public AsciidocBackend(String name, String extension) throws IOException {
        this.name = name;
        this.extension = extension;
        this.transformations = new AsciidocBackendTransformation[0];
        this.temporaryDirectory = File.createTempFile("temp", Long.toString(System.nanoTime()));
        this.temporaryDirectory.delete();
        this.temporaryDirectory.mkdir();
    }

    public AsciidocBackend(String name, String extension, String extension2, String stylesheet) throws IOException {
        this.name = name;
        this.extension = extension;
        this.transformations = new AsciidocBackendTransformation[1];
        this.transformations[0] = new AsciidocBackendTransformation(extension2, stylesheet);
        this.temporaryDirectory = File.createTempFile("temp", Long.toString(System.nanoTime()));
        this.temporaryDirectory.delete();
        this.temporaryDirectory.mkdir();
    }

    public AsciidocBackend(String name, String extension, String extension2, String stylesheet, String extension3, String stylesheet2) throws IOException {
        this.name = name;
        this.extension = extension;
        this.transformations = new AsciidocBackendTransformation[2];
        this.transformations[0] = new AsciidocBackendTransformation(extension2, stylesheet);
        this.transformations[1] = new AsciidocBackendTransformation(extension3, stylesheet2);
        this.temporaryDirectory = File.createTempFile("temp", Long.toString(System.nanoTime()));
        this.temporaryDirectory.delete();
        this.temporaryDirectory.mkdir();
    }

    public String getOutputFile(String inputName) throws IOException {
        String atomicName = FilenameUtils.removeExtension((String)inputName);
        return FileUtils.getAsciidocTemporaryPath(atomicName, this.extension);
    }

    public String getOutputFilePDF(String inputName) throws IOException {
        String atomicName = FilenameUtils.removeExtension((String)inputName);
        return FileUtils.getAsciidocTemporaryPath(atomicName, ".pdf");
    }

    public AsciidocBackendTransformation[] getTransformations() {
        return this.transformations;
    }

    public void setTransformations(AsciidocBackendTransformation[] transformations) {
        this.transformations = transformations;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}

