/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.maven.asciidoc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.rwx.maven.asciidoc.AsciidocCompiler;
import net.rwx.maven.asciidoc.Document;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class AsciidocMojo
extends AbstractMojo {
    private String defaultDocumentType;
    private String defaultOutputPath;
    private String defaultBackend;
    private File projectFile;
    private List<Document> documents;

    private void computeDocument(Document document) {
        if (document.getBackend() == null) {
            document.setBackend(this.defaultBackend);
        }
        if (document.getDocumentType() == null) {
            document.setDocumentType(this.defaultDocumentType);
        }
        if (document.getOutputPath() == null) {
            document.setOutputPath(this.defaultOutputPath);
        }
        String realPath = this.projectFile.getParent() + File.separator + document.getPath();
        document.setPath(realPath);
    }

    private AsciidocCompiler getCompiler() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Unpacking Asciidoc");
            return new AsciidocCompiler();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Starting asciidoc compilation");
        this.getLog().info((CharSequence)("Default document type : " + this.defaultDocumentType));
        this.getLog().info((CharSequence)("Default output path : " + this.defaultOutputPath));
        this.getLog().info((CharSequence)("Default backend : " + this.defaultBackend));
        this.getLog().info((CharSequence)("Project file : " + this.projectFile));
        if (this.documents == null) {
            this.getLog().info((CharSequence)"Nothing to be done");
            return;
        }
        this.getLog().info((CharSequence)("There is  " + this.documents.size() + " documents to compile"));
        AsciidocCompiler compiler = this.getCompiler();
        for (Document document : this.documents) {
            this.computeDocument(document);
            this.getLog().info((CharSequence)("Starting compilation of " + document));
            try {
                compiler.setDocument(document);
                compiler.execute();
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)"Unable to compile a document", (Throwable)ex);
            }
        }
    }
}

