/*
 * Decompiled with CFR 0.152.
 */
package net.rwx.maven.asciidoc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.rwx.maven.asciidoc.Document;
import net.rwx.maven.asciidoc.backends.AsciidocBackend;
import net.rwx.maven.asciidoc.backends.AsciidocBackendSingleton;
import net.rwx.maven.asciidoc.backends.AsciidocBackendTransformation;
import net.rwx.maven.asciidoc.utils.FileUtils;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class AsciidocCompiler {
    public static final String VERSION = "8.6.7";
    private String asciidocFile;
    private Document document;

    public AsciidocCompiler() throws IOException {
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = loader.getResourceAsStream("asciidoc.tar.gz");
        this.asciidocFile = FileUtils.getTemporayAsciidoc();
        FileUtils.uncompress(is, this.asciidocFile);
        String xslDocbook = this.getBaseXsl("");
        is = loader.getResourceAsStream("docbook-xsl.tar.gz");
        FileUtils.uncompress(is, xslDocbook);
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    private String getAsciidoc() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.asciidocFile);
        builder.append(File.separator);
        builder.append("asciidoc-");
        builder.append(VERSION);
        builder.append(File.separator);
        builder.append("asciidoc.py");
        return builder.toString();
    }

    private String getBaseXsl(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.asciidocFile);
        builder.append(File.separator);
        builder.append("asciidoc-");
        builder.append(VERSION);
        builder.append(File.separator);
        builder.append("docbook-xsl");
        builder.append(File.separator);
        builder.append(name);
        return builder.toString();
    }

    private String getXsl(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getBaseXsl("docbook-xsl"));
        builder.append(File.separator);
        builder.append(name);
        return builder.toString();
    }

    private void executeAsciidoc(String input, String backend, String output) throws IOException {
        PySystemState state = new PySystemState();
        state.argv.clear();
        state.argv.append((PyObject)new PyString(this.getAsciidoc()));
        state.argv.append((PyObject)new PyString("-b"));
        state.argv.append((PyObject)new PyString(backend));
        state.argv.append((PyObject)new PyString("-a"));
        state.argv.append((PyObject)new PyString("icons"));
        state.argv.append((PyObject)new PyString("--out-file=" + output));
        state.argv.append((PyObject)new PyString(input));
        File fInput = new File(input);
        state.setCurrentWorkingDir(fInput.getParent());
        PythonInterpreter interp = new PythonInterpreter(null, state);
        interp.setOut((OutputStream)System.out);
        interp.exec("import os");
        interp.exec("os.chdir('" + fInput.getParent() + "')");
        interp.exec("os.getcwd()");
        interp.execfile(this.getAsciidoc());
    }

    private void executeTransformation(String input, String stylesheet, String output) throws TransformerConfigurationException, TransformerException, FileNotFoundException {
        try {
            File xmlFile = new File(input);
            File xsltFile = new File(this.getXsl(stylesheet));
            File resultFile = new File(output);
            StreamSource xmlSource = new StreamSource(xmlFile);
            StreamSource xsltSource = new StreamSource(xsltFile);
            StreamResult result = new StreamResult(new BufferedOutputStream(new FileOutputStream(resultFile)));
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("paper.type", "A4");
            String imgDir = new File(this.document.getPath()).getParentFile().getAbsolutePath();
            trans.setParameter("img.src.path", imgDir + "/");
            trans.transform(xmlSource, result);
        }
        catch (IOException ex) {
            Logger.getLogger(AsciidocCompiler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFop(String input, String output) throws FileNotFoundException, FOPException, TransformerConfigurationException, TransformerException, IOException {
        OutputStream out = null;
        try {
            FopFactory fopFactory = FopFactory.newInstance();
            File outputFile = new File(output);
            if (outputFile.exists()) {
                FileUtils.forceDelete((File)outputFile);
            }
            out = new BufferedOutputStream(new FileOutputStream(outputFile));
            Fop fop = fopFactory.newFop("application/pdf", out);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            File inputFile = new File(input);
            FileUtils.copyFileToDirectory((File)inputFile, (File)new File("/tmp"));
            StreamSource src = new StreamSource(inputFile);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        finally {
            out.close();
        }
    }

    public void execute() throws IOException, TransformerConfigurationException, TransformerException, FileNotFoundException, FOPException {
        AsciidocBackendSingleton backends = AsciidocBackendSingleton.getInstance();
        String backendName = this.document.getBackend();
        AsciidocBackend backend = backends.getBackend(backendName);
        String path = this.document.getPath();
        String output = backend.getOutputFile(path);
        this.executeAsciidoc(path, backend.getName(), output);
        for (AsciidocBackendTransformation transformation : backend.getTransformations()) {
            String input = output;
            String stylesheet = transformation.getXsl();
            output = transformation.getOutputFile(input);
            this.executeTransformation(input, stylesheet, output);
        }
        if (this.document.getBackend().equals("pdf")) {
            String input = output;
            output = backend.getOutputFilePDF(input);
            this.executeFop(input, output);
        }
        FileUtils.moveFileToDirectory(output, this.document.getOutputPath());
    }
}

